/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PreventBlockUsePower;
import io.github.apace100.origins.power.PreventItemUsePower;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.netty.buffer.Unpooled;
import java.util.List;
import me.shedaniel.architectury.event.events.InteractionEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class OriginEventHandler {
    public static void register() {
        InteractionEvent.RIGHT_CLICK_BLOCK.register(OriginEventHandler::preventBlockUse);
        InteractionEvent.RIGHT_CLICK_ITEM.register(OriginEventHandler::preventItemUse);
        PlayerEvent.PLAYER_JOIN.register(OriginEventHandler::playerJoin);
        PlayerEvent.PLAYER_RESPAWN.register(OriginEventHandler::respawn);
    }

    private static ActionResultType preventBlockUse(PlayerEntity player, Hand hand, BlockPos blockPos, Direction direction) {
        if (OriginComponent.getPowers((Entity)player, PreventBlockUsePower.class).stream().anyMatch(p -> p.doesPrevent((IWorldReader)player.func_130014_f_(), blockPos))) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static ActionResult<ItemStack> preventItemUse(PlayerEntity user, Hand hand) {
        if (user != null) {
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)user);
            ItemStack stackInHand = user.func_184586_b(hand);
            for (PreventItemUsePower piup : component.getPowers(PreventItemUsePower.class)) {
                if (!piup.doesPrevent(stackInHand)) continue;
                return ActionResult.func_226251_d_((Object)stackInHand);
            }
            return ActionResult.func_226250_c_((Object)user.func_184586_b(hand));
        }
        return ActionResult.func_226250_c_((Object)ItemStack.field_190927_a);
    }

    private static void playerJoin(ServerPlayerEntity player) {
        OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)player);
        OriginLayers.getLayers().stream().filter(x -> x.isEnabled() && !component.hasOrigin((OriginLayer)x)).forEach(layer -> component.setOrigin((OriginLayer)layer, Origin.EMPTY));
        List playerList = player.func_184102_h().func_184103_al().func_181057_v();
        playerList.forEach(spe -> ModComponentsArchitectury.syncWith(spe, (Entity)player));
        OriginComponent.sync((PlayerEntity)player);
        if (!component.hasAllOrigins()) {
            if (component.checkAutoChoosingLayers((PlayerEntity)player, true)) {
                component.sync();
            }
            if (component.hasAllOrigins()) {
                component.getOrigins().values().forEach(o -> o.getPowerTypes().forEach(powerType -> ((Power)component.getPower(powerType)).onChosen(false)));
            } else {
                PacketBuffer data = new PacketBuffer(Unpooled.buffer());
                data.writeBoolean(true);
                NetworkManager.sendToPlayer((ServerPlayerEntity)player, (ResourceLocation)ModPackets.OPEN_ORIGIN_SCREEN, (PacketBuffer)data);
            }
        }
    }

    private static void respawn(ServerPlayerEntity serverPlayerEntity, boolean alive) {
        if (!alive) {
            List<Power> powers = ModComponentsArchitectury.getOriginComponent((Entity)serverPlayerEntity).getPowers();
            powers.forEach(Power::onRespawn);
        }
    }
}

